/* Copyright (c) 2015-2017, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

(function () {

    var backendAPI;
    var Logger;
    module.exports = function(NvBackendAPI, logger){
        backendAPI = NvBackendAPI;
        Logger = logger;

        return{
            sendDownloadSuccess: function(stat){
                try{
                    backendAPI.reportHttpSuccess(function reply(err, data){
                        if(err){
                            Logger.error(err);
                        }
                    }, stat);
                }catch(e){
                    throw(e);
                }
            },
            sendDownloadFailure: function(stat){
                try{
                    backendAPI.reportHttpFailure(function reply(err, data){
                        if(err){
                            Logger.error(err);
                        }
                    }, stat);
                }catch(e){
                    throw(e);
                }
            }
        };
    };
} ());